<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

// Initialize variables
$pan = '';
$result_data = [];
$show_result = false;
$error_msg = '';

// Service Name
$service_name = 'pan-to-aadhaar-masked';

// Fetch service price from database
$fee = 1; // Default price
$priceRow = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT price FROM pricing WHERE service_name='$service_name'"));

if ($priceRow) {
    $fee = (float)$priceRow['price'];
} else {
    // Insert default price if not exists
    mysqli_query($ahk_conn, "INSERT INTO pricing (service_name, price) VALUES ('$service_name', '1')");
}

if (isset($_POST['search'])) {
    $pan = strtoupper(trim(mysqli_real_escape_string($ahk_conn, $_POST['pan'])));
    $username = $udata['phone'];
    $wallet_amount = (float)$udata['balance'];
    $debit_fee = $wallet_amount - $fee;

    // Validate PAN format
    if (strlen($pan) !== 10) {
        echo "<script>Swal.fire('Invalid PAN', 'Please enter a valid 10-digit PAN number.', 'warning');</script>";
    } elseif ($wallet_amount >= $fee) {
        // Validate API Config
        if (empty($new_api_key) || empty($new_api_url)) {
            echo "<script>Swal.fire('System Error', 'New API Configuration Missing. Please check settings.', 'error');</script>";
        } else {
            // Build API URL
            $base_url = rtrim($new_api_url, '/');
            if (strpos($new_api_url, 'index.php') === false) {
                 $api_endpoint = $base_url . '/index.php';
            } else {
                 $api_endpoint = $new_api_url;
            }

            $params = [
                'api_key' => $new_api_key,
                'service' => $service_name,
                'pan'     => $pan
            ];
            
            // Call API
            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => $api_endpoint,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => http_build_query($params),
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => false,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
            ]);
            
            $response = curl_exec($ch);
            $curl_error = curl_error($ch);
            curl_close($ch);

            if ($curl_error) {
                echo "<script>Swal.fire('API Error', '" . addslashes($curl_error) . "', 'error');</script>";
            } else {
                $result = json_decode($response, true);
                
                // Debugging: Log raw response if JSON decode fails
                if (json_last_error() !== JSON_ERROR_NONE) {
                     $raw_preview = substr($response, 0, 200);
                     echo "<script>Swal.fire('API Error', 'Invalid JSON Response: " . addslashes($raw_preview) . "', 'error');</script>";
                } else {
                    
                    // Parse Response
                    // Response format: {"status":"success", ..., "data": { "status":"success", "data": { "pan":"...", "aadhaar_masked":"..." } } }
                    
                    $is_success = false;
                    $inner_data = [];
    
                    if (isset($result['status']) && $result['status'] === 'success') {
                        // Check nested data structure
                        if (isset($result['data']['data']['link_status'])) {
                            $is_success = true;
                            $inner_data = $result['data']['data'];
                        } elseif (isset($result['data']['link_status'])) {
                            $is_success = true;
                            $inner_data = $result['data'];
                        }
                    }
    
                    if ($is_success) {
                        // Debit Wallet
                        $debit = mysqli_query($ahk_conn, "UPDATE users SET balance = balance - {$fee} WHERE phone = '{$username}'");
                        $insert_history = mysqli_query($ahk_conn, "INSERT INTO `wallethistory`
                            (`userid`, `amount`, `balance`, `purpose`, `status`, `type`, `date`)
                            VALUES ('{$username}', '{$fee}', '{$debit_fee}', 'PAN to Aadhaar Masked', '1', 'Debit', NOW())");
    
                        if ($debit && $insert_history) {
                            $show_result = true;
                            $result_data = $inner_data;
                            echo "<script>Swal.fire('Success', 'Details Fetched Successfully', 'success');</script>";
                        } else {
                            echo "<script>Swal.fire('Database Error', 'Failed to update wallet', 'error');</script>";
                        }
                    } else {
                        $msg = $result['message'] ?? 'Unknown Error';
                        if (isset($result['data']['message'])) $msg = $result['data']['message'];
                        
                        echo "<script>Swal.fire('Failed', '" . addslashes($msg) . "', 'error');</script>";
                    }
                }
            }
        }
    } else {
        echo "<script>
            Swal.fire('Insufficient Balance', 'Please Recharge Your Wallet', 'error');
            setTimeout(() => window.location.href = 'wallet.php', 3000);
        </script>";
    }
}
?>

<!-- HTML STARTS -->
<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb -->
        <div class="page-breadcrumb d-flex align-items-center justify-content-between mb-4 p-3 bg-white rounded shadow-sm">
            <div class="d-flex align-items-center">
                <div class="breadcrumb-title pe-3">Services</div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 ps-2">
                        <li class="breadcrumb-item active text-muted" aria-current="page">PAN to Aadhaar Status</li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">
                <!-- Search Form -->
                <div class="col-sm-12 col-xl-6">
                    <div class="bg-white rounded h-100 p-4 shadow-sm">
                        <h6 class="mb-4 text-primary">Search PAN Status</h6>
                        <form method="post">
                            <div class="mb-3">
                                <label for="pan" class="form-label">PAN Number</label>
                                <input type="text" class="form-control" id="pan" name="pan" 
                                       placeholder="Enter 10-digit PAN Number" 
                                       pattern="[A-Z0-9]{10}" 
                                       maxlength="10" 
                                       style="text-transform: uppercase;"
                                       value="<?php echo htmlspecialchars($pan); ?>" required>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-muted">Fee: ₹<?php echo number_format($fee, 2); ?></small>
                                <button type="submit" name="search" class="btn btn-primary">
                                    <i class="bi bi-search me-1"></i> Check Status
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Result Section -->
                <?php if ($show_result && !empty($result_data)): ?>
                <div class="col-sm-12 col-xl-6">
                    <div class="bg-white rounded h-100 p-4 shadow-sm">
                        <h6 class="mb-4 text-success">Result Details</h6>
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <tbody>
                                    <tr>
                                        <th scope="row" style="width: 40%;">PAN Number</th>
                                        <td class="fw-bold"><?php echo htmlspecialchars($result_data['pan'] ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th scope="row">Link Status</th>
                                        <td>
                                            <?php 
                                            $status = $result_data['link_status'] ?? 'N/A';
                                            $badgeClass = (strtolower($status) == 'linked') ? 'bg-success' : 'bg-warning text-dark';
                                            ?>
                                            <span class="badge <?php echo $badgeClass; ?>"><?php echo strtoupper($status); ?></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row">Aadhaar (Masked)</th>
                                        <td><?php echo htmlspecialchars($result_data['aadhaar_masked'] ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th scope="row">Aadhaar Last 4</th>
                                        <td class="fw-bold text-primary"><?php echo htmlspecialchars($result_data['aadhaar_last_4'] ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th scope="row">Message</th>
                                        <td><small><?php echo htmlspecialchars($result_data['message'] ?? ''); ?></small></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include('../template/ahkweb/footer.php'); ?>